#include <iostream>
#include "windows.h"
#include "PEFile.h"
#include "ProcessHelper.h"

using std::endl;
using std::cout;
using std::hex;
using std::dec;

bool unpack(const char *filename)
{
	char *newfile = new char[strlen(filename)+strlen(".unpacked.exe")+1];
	sprintf(newfile,"%s%s\0",filename,".unpacked.exe");
	
	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	memset(&si,0,sizeof(STARTUPINFO));
	memset(&pi,0,sizeof(PROCESS_INFORMATION));
	DWORD ep,oep,imageBase,delta;
	try {
		PEFile pe;
		pe.openFile(filename);
		ep = pe.ntHeaders->OptionalHeader.AddressOfEntryPoint;
		imageBase = pe.ntHeaders->OptionalHeader.ImageBase;
		pe.close();
	}
	catch(int e) {
		char *msg = PEFile::formatErrorMessage(e);
		cout << msg << endl;
		LocalFree(msg);
		return false;
	}
	int result = CreateProcess(filename,0,0,0,0,CREATE_SUSPENDED,0,0,&si,&pi);
	if( !result ) {
		int error = GetLastError();
		char *msg = PEFile::formatErrorMessage(error);
		cout << "CreateProcess() failed: " << msg;
		LocalFree(msg);
		return false;
	}
	cout << "Process created" << endl;
	try {
		CONTEXT ctx;
		memset(&ctx,0,sizeof(CONTEXT));
		ProcessHelper ph(pi.hProcess);
		cout << "Setting breakpoint on jump to oep:" << hex << (imageBase+ep+0x13) << endl;
		ph.addBreakpoint(ep+imageBase+0x13);
		ph.waitForBreakpoint(imageBase+ep+0x13,pi.hThread,ctx);
		ph.removeBreakpoint(ep+imageBase+0x13);
		delta = ph.readDword(imageBase+ep+0x14);
		oep = ep+0x18+delta;
		cout << "Found oep:" << hex << (imageBase+oep) << endl;
		char *clear = new char[0x18];
		memset(clear,0,0x18);
		cout << "Removing unpacking stub" << endl;
		ph.writeData(imageBase+ep,clear,0x18);
		cout << "Dumping process" << endl;
		ph.dumpProcess(imageBase,newfile);
		TerminateProcess(pi.hProcess,0);
	}
	catch(int e) {
		char *msg = ProcessHelper::formatErrorMessage(e);
		cout << msg << endl;
		LocalFree(msg);
		TerminateProcess(pi.hProcess,0);
		return false;
	}
	try {
		PEFile pe(newfile);
		pe.ntHeaders->OptionalHeader.AddressOfEntryPoint = oep;
		pe.close();
	}
	catch(int e) {
		char *msg = PEFile::formatErrorMessage(e);
		cout << msg << endl;
		LocalFree(msg);
		return false;
	}
	
	return true;
}

int main(int argc,char **argv)
{
	if(argc != 2) {
		cout << "USAGE: " << argv[0] << " filename";
		return 1;
	}
	if(unpack(argv[1])) {
		cout << "Unpacking successful" << endl;
	}
	else {
		cout << "Unpacking failed" << endl;
	}
	return 0;
}